import React from "react";
import Navbar from "./Navbar";
import { Toaster } from "@/components/ui/sonner";
import { BluetoothProvider } from "@/contexts/bluetooth-context";

export default function PosLayout({ children }: { children: React.ReactNode }) {
  return (
    <BluetoothProvider>
      <div className="flex flex-col h-screen">
        <Navbar />
        <main className="flex-1 overflow-hidden p-4">
          <Toaster />
          {children}
        </main>
      </div>
    </BluetoothProvider>
  );
}
