<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Carbon;
use Illuminate\Support\Facades\DB;
use Spatie\Permission\Models\Role;
use Spatie\Permission\Models\Permission;

class SettingSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        /**
         * =========================
         * SETTINGS DATA
         * =========================
         */
        $settings = [
            [
                'name' => 'Nama Toko',
                'code' => 'NAME',
                'value' => 'Kaspos',
                'is_active' => 1,
            ],
            [
                'name' => 'Alamat Toko',
                'code' => 'ADDRESS',
                'value' => 'Jl. Kayu Utara No 5 Rt/Rw. 01/03 Matraman Jakarta Timur',
                'is_active' => 1,
            ],
            [
                'name' => 'Tlp Toko',
                'code' => 'PHONE',
                'value' => '085174334016',
                'is_active' => 1,
            ],
            [
                'name' => 'Logo Toko',
                'code' => 'LOGO',
                'value' => '/storage/logos/default.png',
                'is_active' => 1,
            ],
            [
                'name' => 'Server Bt 1',
                'code' => 'PRNT',
                'value' => '49535343-fe7d-4ae5-8fa9-9fafd205e455',
                'is_active' => 1,
            ],
            [
                'name' => 'Server Bt 2',
                'code' => 'PRNT',
                'value' => 'e7810a71-73ae-499d-8c15-faa9aef0c3f2',
                'is_active' => 1,
            ],
        ];

        foreach ($settings as $setting) {
            DB::table('settings')->insert([
                'name' => $setting['name'],
                'code' => $setting['code'],
                'value' => $setting['value'],
                'is_active' => $setting['is_active'],
                'created_at' => Carbon::now(),
                'updated_at' => Carbon::now(),
            ]);
        }

        /**
         * =========================
         * SHIFTS DATA
         * =========================
         */
        $shifts = [
            [
                'name' => 'Pagi',
                'code' => '001',
                'start_time' => '08:00:00',
                'end_time' => '17:00:00',
            ],
        ];

        foreach ($shifts as $shift) {
            DB::table('shifts')->insert([
                'name' => $shift['name'],
                'code' => $shift['code'],
                'start_time' => $shift['start_time'],
                'end_time' => $shift['end_time'],
                'created_at' => Carbon::now(),
                'updated_at' => Carbon::now(),
            ]);
        }

        /**
         * =========================
         * PERMISSIONS
         * =========================
         */
        $permissions = collect([
            'settings-data',
            'settings-bank',
            'settings-shifts',
            'settings-setting',
            'settings-loyalty',
        ])->each(function ($permission) {
            Permission::firstOrCreate([
                'name' => $permission,
            ]);
        });

        /**
         * =========================
         * ROLE
         * =========================
         */
        $role = Role::firstOrCreate([
            'name' => 'settings-full-access',
        ]);

        $role->syncPermissions($permissions);
    }
}
