<?php

namespace Database\Seeders;

use App\Models\AppSetting;
use Illuminate\Database\Seeder;
use Spatie\Permission\Models\Role;
use Spatie\Permission\Models\Permission;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;

class AppSettingSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $permission = Permission::create(['name' => 'settings-module']);
        $role = Role::where('name', 'settings-full-access')->first();
        $role->givePermissionTo($permission);

        collect([
            [
                'key' => 'self_order',
                'name' => 'Fitur Self Order',
                'description' => 'Izinkan aplikasi menggunakan fitur SELF ORDER (Order mandiri)',
                'is_active' => true
            ],
            [
                'key' => 'restaurant',
                'name' => 'Fitur Restoran',
                'description' => 'Izinkan aplikasi menggunakan fitur KDS (Kitchen Display)',
                'is_active' => true
            ],
            [
                'key' => 'waiter_service',
                'name' => 'Fitur Waiter Service',
                'description' => 'Izinkan aplikasi menggunakan fitur pelayanan waiter',
                'is_active' => true
            ],
            [
                'key' => 'partial_payments',
                'name' => 'Fitur Hutang',
                'description' => 'Izinkan aplikasi menggunakan fitur hutang pelanggan',
                'is_active' => true
            ]
        ])->each(function($item){
            AppSetting::create([
                'key' => $item['key'],
                'name' => $item['name'],
                'description' => $item['description'],
                'is_active' => $item['is_active']
            ]);
        });
    }
}
