<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('barcode_templates', function (Blueprint $table) {
            $table->id();
            $table->string('name');
            $table->enum('paper_type', ['roll', 'sheet']);
            $table->decimal('paper_width_mm', 8, 2);
            $table->decimal('paper_height_mm', 8, 2)->nullable();
            $table->decimal('label_width_mm', 8, 2);
            $table->decimal('label_height_mm', 8, 2);
            $table->decimal('gap_horizontal_mm', 8, 2)->default(0);
            $table->decimal('gap_vertical_mm', 8, 2)->default(0);
            $table->decimal('margin_top_mm', 8, 2)->default(0);
            $table->decimal('margin_left_mm', 8, 2)->default(0);
            $table->unsignedInteger('columns')->nullable();
            $table->unsignedInteger('rows')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('barcode_templates');
    }
};
