<?php

namespace App\Http\Middleware;

use Closure;
use App\Models\AppSetting;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Symfony\Component\HttpFoundation\Response;

class CheckAppSetting
{
    /**
     * Handle an incoming request.
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     */
    public function handle(Request $request, Closure $next, string $key): Response
    {
        $isActive = AppSetting::where('key', $key)->value('is_active');

        if (!$isActive) {
            if(Auth::user())
                return redirect()->route('apps.dashboard');

            return redirect()->route('login');
        }

        return $next($request);
    }
}
