<?php

namespace App\Http\Controllers\Settings;

use Inertia\Inertia;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;

class BarcodeLabelController extends Controller
{
    public function index()
    {
        return Inertia::render('settings/barcode-label', [
            'settings' => [
                'label_width' => 100,
                'label_height' => 50,
                'margin_top' => 5,
                'margin_left' => 5,
                'show_product_name' => true,
                'show_price' => true,
                'show_variant' => true,
                'text_size_name' => 7,
                'text_size_variant' => 6,
                'text_size_price' => 8,
                'row_spacing' => 3,
                'column_spacing' => 3,
                'media_type' => 'roll',
                'labels_per_row' => 1,
                'labels_per_sheet' => 30,
            ]

        ]);
    }

    public function store(Request $request)
    {
        // hanya dummy, belum disimpan sungguhan
        return back()->with('success', 'Pengaturan label barcode berhasil disimpan (dummy).');
    }
}
