<?php

namespace App\Http\Controllers\Apps;

use App\Http\Controllers\Controller;
use App\Services\LicenseClientService;
use Illuminate\Http\Request;

class LicenseController extends Controller
{
    public function __construct(
        protected LicenseClientService $license
    ){}

    public function show()
    {
        $current  = $this->license->getCurrent();
        $flashErr = session('license_error');

        return inertia('apps/licenses/index', [
            'current'        => $current,
            'licenseError'   => $flashErr,
        ]);
    }

    public function activate(Request $request)
    {
        $data = $request->validate([
            'license_key' => 'required|string',
        ]);

        $result = $this->license->activate($data['license_key']);

        if (! $result['ok']) {
            return back()->withErrors([
                'license_key' => $result['message'] ?? 'Gagal mengaktivasi lisensi.',
            ])->withInput();
        }

        return redirect()->route('apps.dashboard');
    }
}
